/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.drill;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.drill.DrillActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.drill.DrillBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class DrillMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DrillActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(class_243 camera, class_327 textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        if (VisualizationManager.supportsVisualization((class_1936)context.world)) {
            return null;
        }
        DrillMovementRenderState state = new DrillMovementRenderState(context.localPos);
        state.layer = class_12249.method_75965();
        class_2680 blockState = context.state;
        state.head = CachedBuffers.partial(AllPartialModels.DRILL_HEAD, blockState);
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)DrillBlock.FACING);
        float speed = context.contraption.stalled || !VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153()) ? context.getAnimationSpeed() : 0.0f;
        float time = AnimationTickHolder.getRenderTime() / 20.0f;
        float angle = time * speed % 360.0f;
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * AngleHelper.verticalAngle(facing);
        state.zRot = (float)Math.PI / 180 * angle;
        state.light = class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DrillMovementRenderState
    extends MovementRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer head;
        public float yRot;
        public float xRot;
        public float zRot;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;

        public DrillMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.head.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateZ(this.zRot)).uncenter()).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

